/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE */;
/*!40101 SET SQL_MODE='STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES */;
/*!40103 SET SQL_NOTES='ON' */;


DROP DATABASE IF EXISTS `pos2122`;
CREATE DATABASE `pos2122` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `pos2122`;
CREATE TABLE `acctdet` (
  `adID` bigint(10) NOT NULL AUTO_INCREMENT,
  `ACCTCODE` varchar(6) DEFAULT NULL,
  `ACCTNAME` varchar(50) DEFAULT NULL,
  `ADDRESS1` varchar(30) DEFAULT '',
  `ADDRESS2` varchar(60) DEFAULT '',
  `MOB1` varchar(15) DEFAULT '',
  `MOB2` varchar(15) DEFAULT '',
  `EMAIL` varchar(50) DEFAULT '',
  `CONTPERSON` varchar(30) DEFAULT '',
  `GSTIN` varchar(30) DEFAULT '-',
  `CREDITLIMIT` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`adID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
INSERT INTO `acctdet` VALUES (1,'G00001','BURMAN BRO','BWN','WB','1234567890','0','NO MAIL','','GSTIN',0);
INSERT INTO `acctdet` VALUES (2,'K00001','SUMAN','BWN','WH','1234567890','0','NO MAIL','','NO GSTIN',0);
CREATE TABLE `acctinf` (
  `ACCTCODE` varchar(8) NOT NULL DEFAULT '-',
  `ACCTNAME` varchar(50) DEFAULT '-',
  `GRCODE` char(3) DEFAULT '-',
  `GRNAME` varchar(30) DEFAULT '-',
  `OPBALDR` decimal(10,2) DEFAULT '0.00',
  `OPBALCR` decimal(10,2) DEFAULT '0.00',
  `OPBALDR2` double(10,2) DEFAULT '0.00',
  `OPBALCR2` double(10,2) DEFAULT '0.00',
  `TRANDR` decimal(10,2) DEFAULT '0.00',
  `TRANCR` decimal(10,2) DEFAULT '0.00',
  `TRANDR2` decimal(10,2) DEFAULT '0.00',
  `TRANCR2` decimal(10,2) DEFAULT '0.00',
  `LOCKED` int(3) DEFAULT '0',
  `ISPRIMARY` int(3) DEFAULT '0',
  `LOCID` int(3) DEFAULT '0',
  `OBFIXED` int(3) DEFAULT '0',
  `OB2FIXED` int(3) DEFAULT '0',
  `UserName` varchar(10) DEFAULT '-',
  `EmpName` varchar(30) DEFAULT '-',
  `HostName` varchar(30) DEFAULT '-',
  `IPAdd` varchar(30) DEFAULT '-',
  `UserDate` date DEFAULT '1900-01-01',
  `UserTime` time DEFAULT '00:00:00',
  PRIMARY KEY (`ACCTCODE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `acctinf` VALUES ('A00001','CAPITAL A/C','A','CAPITAL ACCOUNTS',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('G00001','BURMAN BRO','G','SUNDRY CREDITORS',0,0,0,0,1062,1062,0,0,0,0,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('I00001','CASH A/C','I','CASH ACCOUNT',100000,0,0,0,700,4128,220,2564,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('I00002','1ST CASH','I','',0,0,0,0,0,0,0,0,0,0,1,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('I00003','THIRD CASH','I','CASH ACCOUNT',0,0,0,0,0,0,0,0,0,0,3,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('J00001','SBI','J','BANK ACCOUNT',200000,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('J00002','UBI','J','BANK ACCOUNT',0,163966.15,0,0,0,0,0,0,0,0,1,0,0,'1','PURABI_EMPLOYEE','DESKTOP-PD1812V','Not Known','2017-08-29','19:21:25');
INSERT INTO `acctinf` VALUES ('K00001','SUMAN','K','SUNDRY DEBTORS',0,0,0,0,0,0,0,0,0,0,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('L00001','1st test act 2','J','BANK ACCOUNT',0,0,0,0,0,0,0,0,0,0,2,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('O00001','DISCOUNT GIVEN','O','OTHER EXPENSES',0.25,0,0,0,0,0,0,0,1,1,2,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('O00002','SALES COMMISSION','O','OTHER EXPENSES',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('Q00001','DISCOUNT RECEIPT','Q','COMMISSION EARNED/RECEIPTS',0,3595.8,0,0,0,0,0,20,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('R00001','PURCHASE A/C','R','PURCHASE ACCOUNTS',23540060.7,0,0,0,9150,0,3925,0,1,1,2,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('S00001','SALES A/C','S','SALES ACCOUNTS',0,37656.53,0,0,203.4,1672.4,0,192,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00001','SERVICE CHARGE PAID','V','DUTIES & TAXES',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00002','SERVICE CHARGE RECEIVED','V','DUTIES & TAXES',0,0,0,0,0,0,0,0,1,1,2,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00003','CGST INPUT','V','DUTIES & TAXES',2101246.84,0,0,0,729,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00004','SGST INPUT','V','DUTIES & TAXES',2101246.84,0,0,0,729,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00005','IGST INPUT','V','DUTIES & TAXES',0,0,0,0,162,203.4,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00006','CGST OUTPUT','V','DUTIES & TAXES',0,3557.69,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00007','SGST OUTPUT','V','DUTIES & TAXES',0,3557.69,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('V00008','IGST OUTPUT','V','DUTIES & TAXES',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('W00001','SALES RETURN','W','RETURN INWARD',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('W00002','CREDIT NOTE','W','RETURN INWARD',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('X00001','PURCHASE RETURN','X','RETURN OUTWARD',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
INSERT INTO `acctinf` VALUES ('X00002','DEBIT NOTE','X','RETURN OUTWARD',0,0,0,0,0,0,0,0,1,1,0,0,0,'-','-','-','-','1900-01-01','00:00:00');
CREATE TABLE `deletelog` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `UserName` varchar(10) DEFAULT '-',
  `EmpName` varchar(30) DEFAULT '-',
  `HostName` varchar(30) DEFAULT '-',
  `IPAdd` varchar(30) DEFAULT '-',
  `UserDate` date DEFAULT '1900-01-01',
  `UserTime` time DEFAULT '00:00:00',
  `Type` int(1) DEFAULT '0' COMMENT '1=Purchase, 2=Sales, 3=BillReceipt, 4=BillPayment, 5= Challan',
  `BillNo` bigint(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `groupinf` (
  `GrCode` char(1) DEFAULT NULL,
  `GrName` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `groupinf` VALUES ('Z','TRADING PRODUCTS (STOCK)');
INSERT INTO `groupinf` VALUES ('Y','DEPRECIATION');
INSERT INTO `groupinf` VALUES ('X','RETURN OUTWARD');
INSERT INTO `groupinf` VALUES ('W','RETURN INWARD');
INSERT INTO `groupinf` VALUES ('V','DUTIES & TAXES');
INSERT INTO `groupinf` VALUES ('U','TRADING INCOMES');
INSERT INTO `groupinf` VALUES ('T','TRADING EXPENSES');
INSERT INTO `groupinf` VALUES ('S','SALES ACCOUNTS');
INSERT INTO `groupinf` VALUES ('R','PURCHASE ACCOUNTS');
INSERT INTO `groupinf` VALUES ('Q','COMMISSION EARNED/RECEIPTS');
INSERT INTO `groupinf` VALUES ('P','MISC. INCOME/RECEIPTS');
INSERT INTO `groupinf` VALUES ('O','OTHER EXPENSES');
INSERT INTO `groupinf` VALUES ('N','ESTABLISHMENT EXPENSES');
INSERT INTO `groupinf` VALUES ('M','SECURITY/ADVANCES GIVEN');
INSERT INTO `groupinf` VALUES ('L','BAD DEBTS');
INSERT INTO `groupinf` VALUES ('K','SUNDRY DEBTORS');
INSERT INTO `groupinf` VALUES ('J','BANK ACCOUNT');
INSERT INTO `groupinf` VALUES ('I','CASH ACCOUNT');
INSERT INTO `groupinf` VALUES ('H','FIXED ASSETS');
INSERT INTO `groupinf` VALUES ('G','SUNDRY CREDITORS');
INSERT INTO `groupinf` VALUES ('F','OUTSTANDING LIABILITIES');
INSERT INTO `groupinf` VALUES ('E','ADVANCE TAKEN (CAPITAL)');
INSERT INTO `groupinf` VALUES ('D','LOAN REPAYMENT/REFUND');
INSERT INTO `groupinf` VALUES ('C','SECURED LOANS');
INSERT INTO `groupinf` VALUES ('B','DRAWINGS');
INSERT INTO `groupinf` VALUES ('A','CAPITAL ACCOUNTS');
CREATE TABLE `itemsinf` (
  `ITEMCODE` int(11) NOT NULL AUTO_INCREMENT,
  `ITEMNAME` varchar(140) DEFAULT '-',
  `HSN` varchar(8) DEFAULT '-',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `PPRICE` decimal(10,2) DEFAULT '0.00',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `CATEGORY` varchar(30) DEFAULT '-',
  `BRAND` varchar(20) DEFAULT '-',
  `MODEL` varchar(40) DEFAULT '-',
  `SPEC` varchar(50) DEFAULT '-',
  `UNIT` varchar(6) DEFAULT 'Pc',
  `Qty` decimal(10,0) unsigned DEFAULT '0',
  `bkdQty` decimal(10,0) DEFAULT '0',
  `Disc` decimal(10,2) DEFAULT '0.00',
  `Rol` decimal(10,2) DEFAULT '0.00',
  `RoQ` decimal(10,2) DEFAULT '0.00',
  `RoF` decimal(10,2) DEFAULT '1.50',
  `SalesDisc` decimal(10,2) DEFAULT '0.00',
  `DiscStart` date DEFAULT '2000-01-01',
  `DiscEnd` date DEFAULT '2000-01-01',
  `OpQty` decimal(10,2) DEFAULT '0.00',
  `OpBalance` decimal(10,2) DEFAULT '0.00',
  `CGSTp` decimal(10,2) DEFAULT '0.00',
  `SGSTp` decimal(10,2) DEFAULT '0.00',
  `IGSTp` decimal(10,2) DEFAULT '0.00',
  `MaxDiscount` decimal(10,2) DEFAULT '0.00',
  `PurDisc` decimal(10,2) DEFAULT '0.00',
  `isVerified` int(1) DEFAULT '0',
  PRIMARY KEY (`ITEMCODE`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
INSERT INTO `itemsinf` VALUES (1,'PRODUCT 1','HSN123',12,75,250,10,'CAT1','BRAND1','MOD1','SPEC1','KG',0,0,0,0,0,1.5,0,'2000-01-01','2000-01-01',0,0,0,0,0,0,0,0);
INSERT INTO `itemsinf` VALUES (2,'PRODUCT2','HSN456',18,300,150,20,'CAT1','BRAND1','MOD2','SPEC2','PC',0,0,0,0,0,1.5,0,'2000-01-01','2000-01-01',0,0,0,0,0,0,0,0);
INSERT INTO `itemsinf` VALUES (3,'PRODUCT 3','HSN345',18,50,60,10,'CAT1','BRAND1','dd','sss','PC',0,0,0,0,0,1.5,0,'2000-01-01','2000-01-01',0,0,0,0,0,0,0,0);
INSERT INTO `itemsinf` VALUES (4,'PRODUCT 45','HSN444',27,20,30,0,'TEST','NEW','SELECT','SPEC','PC',0,0,0,0,0,1.5,0,'2000-01-01','2000-01-01',0,0,0,0,0,0,0,0);
INSERT INTO `itemsinf` VALUES (5,'abcd','123456',18,100,150,10,'a','b','c','d','pc',0,0,0,0,0,1.5,0,'2000-01-01','2000-01-01',0,0,0,0,0,0,0,0);
INSERT INTO `itemsinf` VALUES (6,'defg','123456',18,0,0,0,'a','b','c','d','pc',0,0,0,0,0,1.5,0,'2000-01-01','2000-01-01',0,0,0,0,0,0,0,0);
CREATE TABLE `journal` (
  `JID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `JDATE` date DEFAULT '0000-00-00',
  `JNO` varchar(14) DEFAULT '-',
  `ENTFROM` varchar(10) DEFAULT '-',
  `AMOUNT` decimal(10,2) DEFAULT '0.00',
  `DRACCTCODE` varchar(8) DEFAULT '-',
  `CRACCTCODE` varchar(8) DEFAULT '-',
  `NARRATION` varchar(200) DEFAULT '-',
  `REFNO` varchar(15) DEFAULT '-',
  `REFDATE` date DEFAULT '0000-00-00',
  `LOCID` int(3) DEFAULT '0',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`JID`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=latin1;
INSERT INTO `journal` VALUES (1,'2022-04-19','P1','PURCHASE',5700,'R00001','G00001','being purchased from SUPPLIER1','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (2,'2022-04-19','P1','PURCHASE',486,'V00003','G00001','being purchased from SUPPLIER1','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (3,'2022-04-19','P1','PURCHASE',486,'V00004','G00001','being purchased from SUPPLIER1','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (4,'2022-04-19','P1','PURCHASE',5700,'R00001','G00001','being purchased from SUPPLIER1','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (5,'2022-04-19','P1','PURCHASE',486,'V00003','G00001','being purchased from SUPPLIER1','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (6,'2022-04-19','P1','PURCHASE',486,'V00004','G00001','being purchased from SUPPLIER1','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (7,'2022-04-19','P2','PURCHASE',1725,'R00001','G00001','being purchased from SUPPLIER1','-','0000-00-00',2,0);
INSERT INTO `journal` VALUES (8,'2022-04-19','S2022-04-19','SALES',897.6,'I00003','S00001','being sold to I00003','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (9,'2022-04-19','S2022-04-19','SALES',102.6,'S00001','V00005','being sold to I00003','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (10,'2022-04-19','S2022-04-19','SALES',54,'I00003','S00001','being sold to I00003','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (11,'2022-04-19','S2022-04-19','SALES',30,'I00003','S00001','being sold to I00003','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (12,'2022-04-19','S2022-04-19','SALES',84,'I00003','S00001','being sold to I00003','-','0000-00-00',2,0);
INSERT INTO `journal` VALUES (13,'2022-04-19','S2022-04-19','SALES',162,'I00003','S00001','being sold to I00003','-','0000-00-00',2,0);
INSERT INTO `journal` VALUES (20,'2022-05-09','P3','PURCHASE',1100,'R00001','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,0);
INSERT INTO `journal` VALUES (21,'2022-05-09','P3','PURCHASE',10,'G00002','Q00001','being purchased from SUPPLIER 2','-','0000-00-00',1,0);
INSERT INTO `journal` VALUES (22,'2022-05-09','P3','PURCHASE',1252,'G00002','I00001','being purchased from SUPPLIER 2','-','0000-00-00',1,0);
INSERT INTO `journal` VALUES (23,'2022-05-09','P4','PURCHASE',1100,'R00001','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,0);
INSERT INTO `journal` VALUES (24,'2022-05-09','P4','PURCHASE',10,'G00002','Q00001','being purchased from SUPPLIER 2','-','0000-00-00',1,0);
INSERT INTO `journal` VALUES (25,'2022-05-09','P4','PURCHASE',1252,'G00002','I00001','being purchased from SUPPLIER 2','-','0000-00-00',1,0);
INSERT INTO `journal` VALUES (26,'2022-05-09','SP26','SP',50,'G00002','I00001','SDFF','FF','2022-05-09',1,0);
INSERT INTO `journal` VALUES (27,'2022-05-09','SP26','SP',10,'G00001','I00001','SDFF','FF','2022-05-09',1,0);
INSERT INTO `journal` VALUES (28,'2022-05-09','SP28','SP',25,'G00002','I00001','VBBV',' ','2022-05-09',1,1);
INSERT INTO `journal` VALUES (29,'2022-05-09','SP28','SP',5,'G00001','I00001','VBBV',' ','2022-05-09',1,1);
INSERT INTO `journal` VALUES (30,'2022-05-09','CR30','CR',10,'I00001','K00001','NN',' ','2022-05-09',1,1);
INSERT INTO `journal` VALUES (31,'2022-05-09','CR30','CR',100,'I00001','K00002','NN',' ','2022-05-09',1,1);
INSERT INTO `journal` VALUES (32,'2022-05-09','CR32','CR',20,'I00001','K00001','JNM',' ','2022-05-09',1,0);
INSERT INTO `journal` VALUES (33,'2022-05-09','CR32','CR',200,'I00001','K00002','JNM',' ','2022-05-09',1,0);
INSERT INTO `journal` VALUES (34,'2022-05-10','P5','PURCHASE',400,'R00001','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (35,'2022-05-10','P5','PURCHASE',54,'V00003','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (36,'2022-05-10','P5','PURCHASE',54,'V00004','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (37,'2022-05-10','P5','PURCHASE',508,'G00002','I00001','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (38,'2022-05-10','P6','PURCHASE',400,'R00001','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (39,'2022-05-10','P6','PURCHASE',54,'V00003','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (40,'2022-05-10','P6','PURCHASE',54,'V00004','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (41,'2022-05-10','P6','PURCHASE',508,'G00002','I00001','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (42,'2022-05-10','P7','PURCHASE',400,'R00001','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (43,'2022-05-10','P7','PURCHASE',54,'V00003','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (44,'2022-05-10','P7','PURCHASE',54,'V00004','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (45,'2022-05-10','P7','PURCHASE',508,'G00002','I00001','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (58,'2022-05-10','P8','PURCHASE',1350,'R00001','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (59,'2022-05-10','P8','PURCHASE',81,'V00003','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (60,'2022-05-10','P8','PURCHASE',81,'V00004','G00002','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (61,'2022-05-10','P8','PURCHASE',1512,'G00002','I00001','being purchased from SUPPLIER 2','-','0000-00-00',1,1);
INSERT INTO `journal` VALUES (62,'2022-05-20','P9','PURCHASE',900,'R00001','G00001','being purchased from BURMAN BRO','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (63,'2022-05-20','P9','PURCHASE',162,'V00005','G00001','being purchased from BURMAN BRO','-','0000-00-00',2,1);
INSERT INTO `journal` VALUES (64,'2022-05-20','P9','PURCHASE',1062,'G00001','I00001','being purchased from BURMAN BRO','-','0000-00-00',2,1);
CREATE TABLE `partytran` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `TRANDATE` date DEFAULT '2000-01-01',
  `ENTRYTYPE` varchar(30) DEFAULT '-',
  `DEBITAMT` double(10,2) DEFAULT '0.00',
  `CREDITAMT` double(10,2) DEFAULT '0.00',
  `PARTYCODE` varchar(10) DEFAULT '-',
  `REFNO` varchar(10) DEFAULT '-',
  `PMTMODE` varchar(30) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '1',
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
INSERT INTO `partytran` VALUES (1,'2022-05-09','PURCHASE',1252,1252,'G00002','3','-',0,1);
INSERT INTO `partytran` VALUES (2,'2022-05-09','PURCHASE',1252,1252,'G00002','P4','-',0,1);
INSERT INTO `partytran` VALUES (3,'2022-05-10','PURCHASE',508,508,'G00002','P5','-',1,1);
INSERT INTO `partytran` VALUES (4,'2022-05-10','PURCHASE',508,508,'G00002','P6','-',1,1);
INSERT INTO `partytran` VALUES (5,'2022-05-10','PURCHASE',508,508,'G00002','P7','-',1,1);
INSERT INTO `partytran` VALUES (9,'2022-05-10','PURCHASE',1512,1512,'G00002','P8','-',1,1);
INSERT INTO `partytran` VALUES (10,'2022-05-20','PURCHASE',1062,1062,'G00001','P9','-',1,2);
CREATE TABLE `payment` (
  `VrNo` varchar(14) NOT NULL DEFAULT '-',
  `VrDate` date DEFAULT '0000-00-00',
  `SupCode` varchar(6) DEFAULT 'x',
  `SupName` varchar(50) DEFAULT 'x',
  `Amount` decimal(10,2) DEFAULT '0.00',
  `CrAcctCode` varchar(8) DEFAULT 'x',
  `CrAcctName` varchar(50) DEFAULT '-',
  `RefNo` varchar(30) DEFAULT '-',
  `RefDate` date DEFAULT '2000-01-01',
  `UserName` varchar(10) DEFAULT '-',
  `EmpName` varchar(30) DEFAULT '-',
  `HostName` varchar(30) DEFAULT '-',
  `IPAdd` varchar(30) DEFAULT '-',
  `UserDate` date DEFAULT '1900-01-01',
  `UserTime` time DEFAULT '00:00:00',
  `SCharge` decimal(10,2) DEFAULT '0.00',
  `TotPayable` decimal(10,2) DEFAULT '0.00',
  `pmtMode` varchar(30) DEFAULT NULL,
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`VrNo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `paymentdet` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `VrNo` varchar(14) NOT NULL DEFAULT '-',
  `VrDate` date DEFAULT '2000-01-01',
  `InvNo` varchar(30) DEFAULT 'x',
  `InvDate` date DEFAULT '0000-00-00',
  `Due` decimal(10,2) unsigned DEFAULT '0.00',
  `Payment` decimal(10,2) unsigned DEFAULT '0.00',
  `BillNo` bigint(10) unsigned zerofill NOT NULL DEFAULT '0000000000',
  `ctrID` int(1) DEFAULT '0',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `pmtmode_mstr` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `pmtmode` varchar(30) DEFAULT NULL,
  `DrAcctCode` varchar(11) DEFAULT '-',
  `DrAcctName` varchar(30) DEFAULT '-',
  `scharge` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
INSERT INTO `pmtmode_mstr` VALUES (6,'CASH','I00001','CASH A/C',0);
INSERT INTO `pmtmode_mstr` VALUES (7,'Credit Card','J00001','SBI',0);
INSERT INTO `pmtmode_mstr` VALUES (8,'CHEQUE','J00002','UBI',0);
CREATE TABLE `purchase` (
  `BILLNO` bigint(15) NOT NULL AUTO_INCREMENT,
  `BILLDATE` date DEFAULT '2000-01-01',
  `INVOICENO` varchar(30) DEFAULT NULL,
  `INVOICEDATE` date DEFAULT '2000-01-01',
  `SUPCODE` varchar(6) DEFAULT NULL,
  `TAXABLEAMT` decimal(10,2) DEFAULT '0.00',
  `GST` decimal(10,2) DEFAULT '0.00',
  `TOTAL` decimal(10,2) DEFAULT '0.00',
  `GRDISC` decimal(10,2) DEFAULT '0.00',
  `NETTOTAL` decimal(10,2) DEFAULT '0.00',
  `PAIDAMT` decimal(10,2) DEFAULT '0.00',
  `PMTCODE` varchar(10) DEFAULT '-',
  `IGSTMODE` int(3) DEFAULT '0',
  `GSTIN` varchar(30) DEFAULT '-',
  `LOCID` int(3) DEFAULT '0',
  `WHID` int(3) DEFAULT '0',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`BILLNO`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
INSERT INTO `purchase` VALUES (1,'2022-04-19','456','2022-04-19','G00001',5700,972,6672,0,6672,0,'0',0,'19AJUPS8663C1ZE',2,0,1);
INSERT INTO `purchase` VALUES (2,'2022-04-19','999','2022-04-19','G00001',1725,364.5,2089.5,0,2089.5,0,'0',0,'19AJUPS8663C1ZE',2,0,0);
INSERT INTO `purchase` VALUES (3,'2022-05-09','11155','2022-05-09','G00002',1100,162,1262,10,1252,1252,'I00001',0,'19AAFF17328J1ZO',1,2,0);
INSERT INTO `purchase` VALUES (4,'2022-05-09','111','2022-05-09','G00002',1100,162,1262,10,1252,1252,'I00001',0,'19AAFF17328J1ZO',1,2,0);
INSERT INTO `purchase` VALUES (5,'2022-05-10','12345688','2022-05-10','G00002',400,108,508,0,508,508,'I00001',0,'19AAFF17328J1ZO',1,3,1);
INSERT INTO `purchase` VALUES (6,'2022-05-10','123456889','2022-05-10','G00002',400,108,508,0,508,508,'I00001',0,'19AAFF17328J1ZO',1,3,1);
INSERT INTO `purchase` VALUES (7,'2022-05-10','123456','2022-05-10','G00002',400,108,508,0,508,508,'I00001',0,'19AAFF17328J1ZO',1,3,1);
INSERT INTO `purchase` VALUES (8,'2022-05-10','1111','2022-05-10','G00002',1350,162,1512,0,1512,1512,'I00001',0,'19AAFF17328J1ZO',1,3,1);
INSERT INTO `purchase` VALUES (9,'2022-05-20','5656','2022-05-20','G00001',900,162,1062,0,1062,1062,'I00001',1,'GSTIN',2,1,1);
CREATE TABLE `purchasedet` (
  `PDId` bigint(15) NOT NULL AUTO_INCREMENT,
  `BILLNO` bigint(10) DEFAULT '0',
  `BILLDATE` date DEFAULT '2000-01-01',
  `ITEMCODE` int(11) DEFAULT '0',
  `QTY` decimal(10,2) DEFAULT '0.00',
  `FREE` decimal(10,2) DEFAULT '0.00',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `PPRICE` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `TAXABLEAMT` decimal(10,2) DEFAULT '0.00',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `GSTA` decimal(10,2) DEFAULT '0.00',
  `TOTAL` decimal(10,2) DEFAULT '0.00',
  `NPP` decimal(10,2) DEFAULT '0.00',
  `LOTNO` varchar(50) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '0',
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`PDId`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;
INSERT INTO `purchasedet` VALUES (1,1,'2022-04-19',1,10,0,250,100,10,900,12,108,1008,0,'P00001R00250',1,2);
INSERT INTO `purchasedet` VALUES (2,1,'2022-04-19',2,20,2,150,300,20,4800,18,864,5664,0,'P00002R00150',1,2);
INSERT INTO `purchasedet` VALUES (4,2,'2022-04-19',3,25,0,60,50,10,1125,18,202.5,1327.5,0,'P00003R00060',0,2);
INSERT INTO `purchasedet` VALUES (5,2,'2022-04-19',4,30,0,30,20,0,600,27,162,762,0,'P00004R00030',0,2);
INSERT INTO `purchasedet` VALUES (12,3,'2022-05-09',3,20,0,60,50,10,900,18,162,1062,0,'P00003R00060',0,1);
INSERT INTO `purchasedet` VALUES (13,3,'2022-05-09',4,10,0,30,20,0,200,27,0,200,0,'P00004R00030',0,1);
INSERT INTO `purchasedet` VALUES (15,5,'2022-05-10',4,20,0,30,20,0,400,27,108,508,0,'G1P00004R00030',1,1);
INSERT INTO `purchasedet` VALUES (19,8,'2022-05-10',1,20,0,250,75,10,1350,12,162,1512,0,'G1P00001R00250',1,1);
INSERT INTO `purchasedet` VALUES (20,9,'2022-05-20',5,10,0,150,100,10,900,18,162,1062,0,'G1P00005R00150',1,2);
CREATE TABLE `purchasetmp` (
  `PTID` int(11) NOT NULL AUTO_INCREMENT,
  `INVOICENO` varchar(30) DEFAULT '-',
  `ITEMCODE` int(11) DEFAULT '0',
  `QTY` decimal(10,2) DEFAULT '0.00',
  `FREE` decimal(10,2) DEFAULT '0.00',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `PPRICE` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `TAXABLEAMT` decimal(10,2) DEFAULT '0.00',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `GSTA` decimal(10,2) DEFAULT '0.00',
  `TOTAL` decimal(10,2) DEFAULT '0.00',
  `NPP` decimal(10,2) DEFAULT '0.00',
  `LOTNO` varchar(50) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`PTID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
INSERT INTO `purchasetmp` VALUES (4,'899',3,10,0,60,50,10,450,18,81,531,0,'G1P00003R00060',1);
CREATE TABLE `receipt` (
  `VrNo` varchar(14) NOT NULL DEFAULT '-',
  `VrDate` date DEFAULT '0000-00-00',
  `CustCode` varchar(6) DEFAULT 'x',
  `CustName` varchar(50) DEFAULT 'x',
  `Amount` decimal(10,2) DEFAULT '0.00',
  `DrAcctCode` varchar(6) DEFAULT 'x',
  `DrAcctName` varchar(50) DEFAULT '-',
  `RefNo` varchar(30) DEFAULT '-',
  `RefDate` date DEFAULT '2000-01-01',
  `UserName` varchar(10) DEFAULT '-',
  `EmpName` varchar(30) DEFAULT '-',
  `HostName` varchar(30) DEFAULT '-',
  `IPAdd` varchar(30) DEFAULT '-',
  `UserDate` date DEFAULT '1900-01-01',
  `UserTime` time DEFAULT '00:00:00',
  `SCharge` decimal(10,2) DEFAULT '0.00',
  `TotPayable` decimal(10,2) DEFAULT '0.00',
  `pmtMode` varchar(30) DEFAULT NULL,
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`VrNo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `receiptdet` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `VrNo` varchar(14) NOT NULL DEFAULT '-',
  `VrDate` date DEFAULT '2000-01-01',
  `BillNo` bigint(10) unsigned zerofill NOT NULL DEFAULT '0000000000',
  `BillDate` date DEFAULT '0000-00-00',
  `Due` decimal(10,2) unsigned DEFAULT '0.00',
  `Payment` decimal(10,2) unsigned DEFAULT '0.00',
  `ctrID` int(1) DEFAULT '0',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `sales` (
  `BILLSL` bigint(16) unsigned NOT NULL AUTO_INCREMENT,
  `BILLNO` int(11) DEFAULT '0',
  `BLTYPE` int(3) DEFAULT '0',
  `BILLDATE` date DEFAULT '2000-01-01',
  `CUSTNAME` varchar(50) DEFAULT NULL,
  `MOBILE` varchar(15) DEFAULT NULL,
  `MATVAL` decimal(10,2) DEFAULT '0.00',
  `GSTA` decimal(10,2) DEFAULT '0.00',
  `NETTOTAL` decimal(10,2) DEFAULT '0.00',
  `PAIDAMT` decimal(10,2) DEFAULT '0.00',
  `PARTYCODE` varchar(6) DEFAULT NULL,
  `GSTIN` varchar(30) DEFAULT '-',
  `LOCID` int(3) DEFAULT '0',
  PRIMARY KEY (`BILLSL`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;
INSERT INTO `sales` VALUES (1,1,1,'2022-03-17','2ND CUSTOMER','7001624904',1080,129.6,1209.6,1209.6,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (2,2,1,'2022-03-17','3RD CUSTOMER','7001624913',300,0,300,300,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (3,3,1,'2022-03-17','2ND CUSTOMER','7001624904',540,64.8,604.8,604.8,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (4,4,1,'2022-03-17','2ND CUSTOMER','7001624904',540,64.8,604.8,604.8,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (5,5,1,'2022-03-17','2ND CUSTOMER','7001624904',540,64.8,604.8,604.8,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (6,6,1,'2022-03-17','2ND CUSTOMER','7001624904',540,64.8,604.8,604.8,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (7,7,1,'2022-03-17','2ND CUSTOMER','7001624904',540,64.8,604.8,604.8,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (8,8,1,'2022-03-17','2ND CUSTOMER','7001624904',540,64.8,604.8,604.8,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (9,9,1,'2022-03-17','3RD CUSTOMER','7001624913',318.75,57.37,376.13,376.13,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (10,10,1,'2022-03-17','2ND CUSTOMER','7001624904',630,75.6,705.6,705.6,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (11,11,1,'2022-03-17','3RD CUSTOMER','7001624913',637.5,114.75,752.25,752.25,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (12,12,1,'2022-03-17','4TH CUSTOMER','7797795423',3046.5,365.58,3412.08,3412.08,'I00001','NO GSTIN',1);
INSERT INTO `sales` VALUES (13,13,1,'2022-03-30','2ND CUSTOMER','7001624904',1552.5,186.3,1738.8,1738.8,'I00001','NO GSTIN',2);
INSERT INTO `sales` VALUES (14,14,1,'2022-04-06','3RD CUSTOMER','7001624913',360,64.8,424.8,424.8,'I00001','NO GSTIN',2);
INSERT INTO `sales` VALUES (15,15,1,'2022-04-19','2ND CUSTOMER','7001624904',795,102.6,897.6,897.6,'I00003','NO GSTIN',2);
INSERT INTO `sales` VALUES (16,16,1,'2022-04-19','2ND CUSTOMER','7001624904',54,0,54,54,'I00003','NO GSTIN',2);
INSERT INTO `sales` VALUES (17,17,1,'2022-04-19','2ND CUSTOMER','7001624904',30,0,30,30,'I00003','NO GSTIN',2);
INSERT INTO `sales` VALUES (18,18,0,'2022-04-19','2ND CUSTOMER','7001624904',30,0,30,30,'I00003','NO GSTIN',2);
INSERT INTO `sales` VALUES (19,18,0,'2022-04-19','2ND CUSTOMER','7001624904',108,0,108,108,'I00003','NO GSTIN',2);
INSERT INTO `sales` VALUES (20,18,0,'2022-04-19','2ND CUSTOMER','7001624904',54,0,54,54,'I00003','NO GSTIN',2);
INSERT INTO `sales` VALUES (21,18,1,'2022-05-16','','',90,10.8,100.8,100.8,'','NO GSTIN',1);
INSERT INTO `sales` VALUES (22,19,1,'2022-05-20','','',500,90,590,590,'I00001','NO GSTIN',2);
CREATE TABLE `salesdet` (
  `SDid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `BILLDATE` date DEFAULT '2000-01-01',
  `STKID` int(11) DEFAULT '0',
  `BILLNO` bigint(15) unsigned DEFAULT '0',
  `ITEMCODE` varchar(6) DEFAULT NULL,
  `QTY` decimal(10,2) DEFAULT '0.00',
  `UNIT` varchar(10) DEFAULT NULL,
  `MRP` decimal(10,2) DEFAULT '0.00',
  `DISCP` decimal(10,2) DEFAULT '0.00',
  `DISCA` decimal(10,2) DEFAULT '0.00',
  `MATVAL` decimal(10,2) DEFAULT '0.00',
  `GSTP` decimal(10,2) DEFAULT '0.00',
  `CGST` decimal(10,2) DEFAULT '0.00',
  `SGST` decimal(10,2) DEFAULT '0.00',
  `NETTOTAL` decimal(10,2) DEFAULT '0.00',
  `HSN` varchar(30) DEFAULT NULL,
  `WHID` int(3) DEFAULT '0',
  PRIMARY KEY (`SDid`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
INSERT INTO `salesdet` VALUES (1,'2000-01-01',3,1,'1',2,NULL,600,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (2,'2000-01-01',2,2,'2',1,NULL,400,25,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (3,'2000-01-01',3,3,'1',1,NULL,600,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (4,'2000-01-01',3,4,'1',1,NULL,600,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (5,'2000-01-01',3,5,'1',1,NULL,600,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (6,'2000-01-01',3,6,'1',1,NULL,600,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (7,'2000-01-01',3,7,'1',1,NULL,600,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (8,'2000-01-01',3,8,'1',1,NULL,600,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (9,'2000-01-01',58,9,'2',1,NULL,425,25,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (10,'2000-01-01',57,10,'1',2,NULL,350,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (11,'2000-01-01',58,12,'2',2,NULL,425,25,0,0,9,10,0,10,NULL,0);
INSERT INTO `salesdet` VALUES (12,'2000-01-01',3,12,'1',1,NULL,600,10,0,0,9,10,0,20,NULL,0);
INSERT INTO `salesdet` VALUES (13,'2000-01-01',59,12,'1',3,NULL,345,10,0,0,18,15,0,30,NULL,0);
INSERT INTO `salesdet` VALUES (14,'2000-01-01',57,12,'1',5,NULL,350,10,0,0,18,15,0,40,NULL,0);
INSERT INTO `salesdet` VALUES (15,'2000-01-01',77,13,'1',2,NULL,345,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (16,'2000-01-01',76,13,'1',3,NULL,345,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (17,'2000-01-01',67,14,'2',1,NULL,400,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (18,'2000-01-01',68,14,'1',1,NULL,345,100,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (19,'2000-01-01',1,15,'1',1,NULL,250,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (20,'2000-01-01',2,15,'2',1,NULL,150,20,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (21,'2000-01-01',1,15,'1',1,NULL,250,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (22,'2000-01-01',1,15,'1',1,NULL,250,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (23,'2000-01-01',3,16,'3',1,NULL,60,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (24,'2000-01-01',4,17,'4',1,NULL,30,0,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (25,'2000-01-01',4,18,'4',1,NULL,30,0,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (26,'2000-01-01',3,18,'3',2,NULL,60,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (27,'2000-01-01',3,18,'3',1,NULL,60,10,0,0,0,0,0,0,NULL,0);
INSERT INTO `salesdet` VALUES (28,'2000-01-01',7,18,'1',1,NULL,100,10,0,0,0,0,0,0,NULL,3);
INSERT INTO `salesdet` VALUES (29,'2000-01-01',6,19,'3',1,NULL,500,0,0,0,0,0,0,0,NULL,2);
CREATE TABLE `salesdetbar` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `brCode` varchar(50) DEFAULT NULL,
  `SDID` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `salesperson` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `SalesPerson` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `settings` (
  `ID` int(11) DEFAULT NULL,
  `PurBill` int(11) DEFAULT '0',
  `ChallanNo` int(11) DEFAULT '0',
  `salebill` int(11) NOT NULL DEFAULT '0',
  `OrderBill` int(11) DEFAULT '0',
  `SaleRefNo` int(11) DEFAULT '0',
  `SaleTmp` bigint(17) DEFAULT '0',
  `StockVal` int(1) DEFAULT '0' COMMENT '0=Avg Pur Pr, 1=Actual Price',
  `SlipSaleID` int(12) unsigned DEFAULT '0',
  `PurTmp` bigint(17) DEFAULT '0',
  `ReturnPd` int(5) DEFAULT '0',
  `RV` int(11) DEFAULT NULL,
  `PV` int(11) DEFAULT NULL,
  `JV` int(11) DEFAULT NULL,
  `RoT` decimal(6,2) DEFAULT '0.00',
  `ItemCode` int(11) DEFAULT '0',
  `BID` int(11) DEFAULT '0',
  `SCharge` varchar(8) DEFAULT NULL,
  `AdvCode` varchar(8) DEFAULT '-',
  `SKey` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`salebill`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `settings` VALUES (1,0,0,0,0,0,0,0,0,0,0,142,34,0,0,0,0,'O00001','O00002','1234');
CREATE TABLE `stock` (
  `STKID` int(11) NOT NULL AUTO_INCREMENT,
  `ITEMCODE` int(11) DEFAULT '0',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `QTY` int(10) DEFAULT '0',
  `LOTNO` varchar(50) DEFAULT '-',
  `NPP` double(10,2) DEFAULT '0.00',
  `WHID` int(3) DEFAULT '0',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`STKID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
INSERT INTO `stock` VALUES (1,1,100,7,'G1P00001R00250',0,1,0);
INSERT INTO `stock` VALUES (2,2,200,21,'P00002R00150',0,2,1);
INSERT INTO `stock` VALUES (3,3,300,21,'P00003R00060',0,3,0);
INSERT INTO `stock` VALUES (4,4,400,28,'P00004R00030',0,1,0);
INSERT INTO `stock` VALUES (6,3,500,9,'G1P00003R00060',0,2,1);
INSERT INTO `stock` VALUES (7,1,100,19,'G1P00001R00250',0,3,1);
INSERT INTO `stock` VALUES (8,5,150,10,'G1P00005R00150',0,1,1);
CREATE TABLE `stockbar` (
  `BARCODE` varchar(50) NOT NULL DEFAULT '',
  `LOTNO` bigint(15) DEFAULT '0',
  `pdid` bigint(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `stocktransfer` (
  `STID` int(11) NOT NULL AUTO_INCREMENT,
  `CHALLANNO` varchar(30) DEFAULT '-',
  `CHALLANDATE` date DEFAULT '2000-01-01',
  `ITEMCODE` int(11) DEFAULT '0',
  `MRP` decimal(10,2) DEFAULT '0.00',
  `TRANSFERQTY` int(3) DEFAULT '0',
  `RECEIPTQTY` int(3) DEFAULT '0',
  `LOC1` int(3) DEFAULT '0',
  `LOC2` int(3) DEFAULT '0',
  `STKID` int(11) DEFAULT '0',
  `LOTNO` varchar(50) DEFAULT '-',
  `BLTYPE` int(3) DEFAULT '0',
  PRIMARY KEY (`STID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
